 IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_BalanceSaldoMesCentro_Rpt]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_BalanceSaldoMesCentro_Rpt] 
END
GO
CREATE PROCEDURE [dbo].[CPJ_BalanceSaldoMesCentro_Rpt]	@pJson VARCHAR(8000)
AS
SET NOCOUNT ON

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pModoDebug			    		TINYINT
DECLARE @pId_Usuario					SMALLINT
DECLARE @pPeriodo_Desde					DATETIME
DECLARE @pPeriodo_Hasta					DATETIME
DECLARE @pFlag_incluirSoloAsientos		TINYINT
DECLARE @pFlag_FiltrarId_CC				TINYINT
DECLARE @pId_Centro_Costo				CHAR(10)
DECLARE @pId_Plan_Cta					INT
DECLARE @pFlag_Desglozar_CC	    		TINYINT
DECLARE @pFlag_Excluir_Asientos_Cierre	TINYINT
DECLARE @pId_Alias_Cta_Contable			INT
DECLARE @pSoloResultado	    		TINYINT
DECLARE @pIncluirCCNoDef	    	TINYINT
DECLARE @pId_Unid_Negocio			CHAR(10)


SET @pIncluirCCNoDef			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'IncluirCCNoDef')), 0)
SET @pSoloResultado				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'SoloResultado')), 0)
SET @pFlag_FiltrarId_CC			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_FiltrarId_CC')), 0)

SET @pModoDebug						= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario					= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pPeriodo_Desde					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Periodo_Desde')), '19000101')
SET @pPeriodo_Hasta					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Periodo_Hasta')), '19000101')
SET @pFlag_incluirSoloAsientos		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_incluirSoloAsientos')), 0)
SET @pFlag_FiltrarId_CC				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_FiltrarId_CC')), 0)
SET @pId_Centro_Costo				= ISNULL(CONVERT(Char(10), dbo.CF_JSON_VALUE(@pJson,'Id_Centro_Costo')), '')
SET @pId_Plan_Cta					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Plan_Cta')), 0)
SET @pId_Unid_Negocio				= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Unid_Negocio')), '')
SET @pFlag_Desglozar_CC				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Desglozar_CC')), 0)
SET @pFlag_Excluir_Asientos_Cierre	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Excluir_Asientos_Cierre')), 0)
SET @pId_Alias_Cta_Contable			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Alias_Cta_Contable')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @SqlStr						NVARCHAR(MAX)
DECLARE @TipoAsientoCierre			VARCHAR(8000)
DECLARE @Id_Cta_Contable			INT
DECLARE @Debe_Suma					DECIMAL(30,2)
DECLARE @Haber_Suma					DECIMAL(30,2)
DECLARE @Nro_Cta_Contable			VARCHAR(20)
DECLARE @Alias						DECIMAL(12,0)
DECLARE @Cta_Contable				VARCHAR(80)
DECLARE @Id_Centro_Costo			CHAR(10)
DECLARE @Centro_Costo				VARCHAR(200)
DECLARE @Anterior					DECIMAL(30,2)
DECLARE @Debe						DECIMAL(30,2)
DECLARE @Haber						DECIMAL(30,2)
DECLARE @Diferencia					DECIMAL(30,2)
DECLARE @Deudor						DECIMAL(30,2)
DECLARE @Acreedor					DECIMAL(30,2)
DECLARE @Columna_Bal				INT
DECLARE @Alias_Cta_Padre			DECIMAL(12,0)
DECLARE @PCE_Fecha_Inicio			DATETIME
DECLARE @PCE_Fecha_Cierre			DATETIME
DECLARE @Id_Ejercicio				INT
DECLARE @Flag_Existe_Registro_En_Cola TINYINT
DECLARE @Periodo                    DATE
DECLARE @Saldo                      DECIMAL(30,2)
/*FIN Variables Locales*/


BEGIN TRY
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Balance_Sumas_Saldos_Rpt'
		PRINT 'Parametros: '
		PRINT '@pId_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario) + '. @pPeriodo_Desde: ' + CONVERT(VARCHAR(10), @pPeriodo_Desde, 112) + '. @pPeriodo_Hasta: ' + CONVERT(VARCHAR(10), @pPeriodo_Hasta, 112) +'. @pFlag_FiltrarId_CC: ' + CONVERT(VARCHAR(10), @pFlag_FiltrarId_CC) + '. @pId_Centro_Costo: ' + CONVERT(VARCHAR(10), @pId_Centro_Costo)
		PRINT '@pFlag_incluirSoloAsientos: ' + CONVERT(VARCHAR(10), @pFlag_incluirSoloAsientos) + '. @pId_Plan_Cta: ' + CONVERT(VARCHAR(10), @pId_Plan_Cta) + '. @pId_Unid_Negocio: ' + @pId_Unid_Negocio + '. @pFlag_Desglozar_CC: ' + CONVERT(VARCHAR(10), @pFlag_Desglozar_CC) + '. @pFlag_Excluir_Asientos_Cierre: ' + CONVERT(VARCHAR(10), @pFlag_Excluir_Asientos_Cierre) 
	END

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pId_Usuario = 0)
	BEGIN
		SET @pId_Usuario = -1
	END
	
	IF(@pPeriodo_Desde = '19000101')								RAISERROR ('Periodo_Desde can not be blank.', 16,  1)
	IF(@pPeriodo_Hasta = '19000101')								RAISERROR ('Periodo_Hasta can not be blank.', 16,  1) 
	IF(@pPeriodo_Desde >= @pPeriodo_Hasta)							RAISERROR ('Periodo_Desde can not be bigger or equal than Periodo_Hasta.', 16,  1) 
	--IF(DATEDIFF(YEAR, @pPeriodo_Desde, @pPeriodo_Hasta) > 0)		RAISERROR ('Diference between Periodo_Desde and Periodo_Hasta can not be bigger than a year.', 16,  1) 	
	IF(@pId_Plan_Cta = 0)										RAISERROR ('Id_Plan_Cta can not be zero.', 16,  1) 
	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		IF(@pId_Centro_Costo = '')								RAISERROR ('ID_Centro_Costo can not be blank.', 16,  1)
	END
	
	/*=============================================================================================================================*/

	SET @TipoAsientoCierre = dbo.CF_xParam('Tipo_Asto_Cierre')
	SELECT 	@Id_Ejercicio	= ISNULL(Id_Ejercicio, 0) 	FROM Plan_Ctas 	WHERE 	Id_Plan_Cta = @pId_Plan_Cta

	SELECT 	@PCE_Fecha_Inicio = ISNULL(Fecha_Inicio, '19000101'),
			@PCE_Fecha_Cierre = ISNULL(Fecha_Cierre, '19000101')
			FROM Plan_Ctas_Ejercicios WHERE Id_Ejercicio = @Id_Ejercicio

	/*=============================================================================================================================*/
    Update Cbtes_Ctas_Contables  set Id_Centro_Costo = '' where Id_centro_costo is null
	Update Asientos_Items  set Id_Centro_Costo = '' where Id_centro_costo is null

	/*=============================================================================================================================*/
    
    SELECT Id_Cta_Contable,Id_Centro_Costo into  #Rpt_Balance_Saldo_x_Mes_CC FROM  Asientos_Items where 1=0 
    
    
    ALTER TABLE  #Rpt_Balance_Saldo_x_Mes_CC ADD
	Nro_Cta_Contable				VARCHAR(20),
	Alias							INT,
	Cta_Contable					VARCHAR(80),
	Centro_Costo					VARCHAR(200),
	Id_cuenta_Padre					INT,
	Mes_01							DECIMAL(16,2),
	Mes_02							DECIMAL(16,2),
	Mes_03							DECIMAL(16,2),
	Mes_04							DECIMAL(16,2),
	Mes_05							DECIMAL(16,2),
	Mes_06							DECIMAL(16,2),
	Mes_07							DECIMAL(16,2),
	Mes_08							DECIMAL(16,2),
	Mes_09							DECIMAL(16,2),
	Mes_10							DECIMAL(16,2),
	Mes_11							DECIMAL(16,2),
	Mes_12							DECIMAL(16,2),
	Total							DECIMAL(16,2)
	
	
	
	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'ASIENTOS'
	END

    Select Id_Cta_Contable,Id_Centro_Costo into  #Asientos_Sumas_Saldos FROM  Asientos_Items where 1=0

	ALTER TABLE #Asientos_Sumas_Saldos ADD
	            Periodo                         DATE,
	            Saldo						    DECIMAL(30,2)

	/*========================================================Saldos de asientos =====================================================================*/

	SET @SqlStr = 'INSERT INTO #Asientos_Sumas_Saldos (Id_Cta_Contable, Id_Centro_Costo, Periodo, Saldo) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
					'SELECT '															+ CHAR(13) + 
					'Id_Cta_Contable, '													+ CHAR(13) +
					'I.Id_Centro_Costo , '			                                	+ CHAR(13) +
                    ' Substring(Convert(Nvarchar,A.fecha,112),1,6)+''01'' AS Periodo, ' + CHAR(13) +
			    	' SUM(ISNULL(I.Debe-I.Haber,0)) as Saldo '					    	+ CHAR(13) + 
					'FROM Asientos_Items I, Asientos A '								+ CHAR(13) + 
					'WHERE '															+ CHAR(13) + 
					'A.Id_Asiento = I.Id_Asiento '										+ CHAR(13) + 
					'AND A.Balanceado = 1 '												+ CHAR(13) + 
					'AND A.Id_Plan_Cta = '	+ CONVERT(VARCHAR(10), @pId_Plan_Cta)

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Fecha >= ''' + CONVERT(VARCHAR(10), @pPeriodo_Desde, 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Fecha < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pPeriodo_Hasta), 112) + ''' '

	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
	END

	IF(@pId_Unid_Negocio <> '')
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND A.Id_Unid_Negocio = ''' + @pId_Unid_Negocio + ''' '
	END

	IF(@pFlag_Excluir_Asientos_Cierre <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND A.Id_Tipo_Asi NOT IN (' + @TipoAsientoCierre + ') '
	END

	IF(@pId_Alias_Cta_Contable <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Alias_Cta_Cont = ' + CONVERT(VARCHAR(10), @pId_Alias_Cta_Contable) + ' '
	END

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'GROUP BY Id_Cta_Contable,Id_Centro_Costo,Substring(convert(nvarchar,A.fecha,112),1,6)+''01'' ORDER BY Id_Cta_Contable,Id_Centro_Costo  '

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'Saldos de asientos @SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr

--	SELECT * FROM #Asientos_Sumas_Saldos


	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'COMPROBANTES'
	END

    Select Id_Cta_Contable,Id_Centro_Costo into  #Cbtes_Sumas_Saldos FROM  CBTES_CTAS_CONTABLES where 1=0

	ALTER TABLE #Cbtes_Sumas_Saldos ADD
	            Periodo                         DATE,
	            Saldo						    DECIMAL(30,2)


	/*=============================================================================================================================*/

	SET @SqlStr = 'INSERT INTO #Cbtes_Sumas_Saldos (Id_Cta_Contable, Id_Centro_Costo, Periodo, Saldo) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
					'SELECT '															+ CHAR(13) + 
					'Id_Cta_Contable, '													+ CHAR(13) +
					'ISNULL(I.Id_Centro_Costo,'''') as Id_Centro_Costo, '				+ CHAR(13) +
                    ' Substring(Convert(Nvarchar,A.Periodo_Iva,112),1,6)+''01'' AS Periodo, ' + CHAR(13) +
			    	' SUM(ISNULL(I.Debe-I.Haber,0)) as Saldo '					    	+ CHAR(13) + 	
					'FROM Cbtes_Ctas_Contables I, Cbtes A, Cbtes_Tipos T '				+ CHAR(13) + 
					'WHERE '															+ CHAR(13) + 
					'A.Id_Trans = I.Id_Trans '											+ CHAR(13) + 
					'AND ISNULL(I.Id_Asiento, 0) = 0 '									+ CHAR(13) + 
					'AND A.Id_Tipo_Cbte = T.Id_Tipo_Cbte '								+ CHAR(13) + 
					'AND ISNULL(T.Compromete_Asientos, 0) <> 0 '						+ CHAR(13) + 
					'AND A.Id_Estado_Cbte <> 0'											+ CHAR(13) + 
					'AND A.Id_Estado_Cbte <> 3'

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva >= ''' + CONVERT(VARCHAR(10), @PCE_Fecha_Inicio, 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @PCE_Fecha_Cierre), 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva >= ''' + CONVERT(VARCHAR(10), @pPeriodo_Desde, 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pPeriodo_Hasta), 112) + ''' '

	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
	END

	IF(@pId_Unid_Negocio <> '')
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND A.Id_Unid_Negocio = ''' + @pId_Unid_Negocio + ''' '
	END

	IF(@pId_Alias_Cta_Contable <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Alias = ' + CONVERT(VARCHAR(10), @pId_Alias_Cta_Contable) + ' '
	END
	
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
	    'GROUP BY I.Id_Cta_Contable,I.Id_Centro_Costo,Substring(convert(nvarchar,A.Periodo_Iva,112),1,6)+''01'' ORDER BY I.Id_Cta_Contable,I.Id_Centro_Costo  '


	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	IF (@pFlag_incluirSoloAsientos = 0)       -- Si es solo asientos, no lo ejecuto
		EXECUTE sp_executesql @SqlStr
	
 --  SELECT * FROM #Cbtes_Sumas_Saldos


   INSERT INTO  #Asientos_Sumas_Saldos  
        SELECT * FROM  #Cbtes_Sumas_Saldos
 

   SELECT ID_CTA_CONTABLE,ID_CENTRO_COSTO,PERIODO,SUM(SALDO) AS SALDO
			INTO #Sumas_Saldos
			FROM #Asientos_Sumas_Saldos
			GROUP BY ID_CTA_CONTABLE,ID_CENTRO_COSTO,PERIODO
			
		
			
-- select * from #Sumas_Saldos
    
 --------------------------------------------------------------------
 
 
	SET @SqlStr =	'INSERT INTO #Rpt_Balance_Saldo_x_Mes_CC (Nro_Cta_Contable, Alias, Cta_Contable, Id_Centro_Costo, Centro_Costo, Id_Cta_Contable, Id_Cuenta_Padre) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
		'SELECT DISTINCT PCCC.Nro_Cta_Contable, PCCC.Alias, PCCC.Descripcion, CC.Id_Centro_Costo, CC.Descripcion, PCCC.Id_Cta_Contable,PCCC.Id_Cuenta_Padre ' + CHAR(13) +
		'FROM Cbtes_Ctas_Contables CCC LEFT JOIN Centro_Costos CC ON CCC.Id_Centro_Costo = CC.Id_Centro_Costo, Pla_Ctas_Cuentas_Contables PCCC ' + CHAR(13) +
		'WHERE ' + CHAR(13) +
		'CCC.Id_Cta_Contable = PCCC.Id_Cta_Contable ' + CHAR(13) +
		'AND PCCC.Id_Plan_Cta = ' + CONVERT(VARCHAR(10), @pId_Plan_Cta) + ' '

	IF(@pIncluirCCNoDef = 0)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'AND (CCC.Id_Centro_Costo <> '''' OR CCC.Id_Centro_Costo IS NOT NULL)  '

	IF(@pFlag_FiltrarId_CC <> 0)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'AND CCC.Id_Centro_Costo = '''+  @pId_Centro_Costo    +''' '

	IF(@pSoloResultado = 1)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'AND PCCC.Tipo IN (''+'',''-'') '
	
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
		'UNION ' + CHAR(13) +
		'SELECT DISTINCT PCCC.Nro_Cta_Contable, PCCC.Alias, PCCC.Descripcion, CC.Id_Centro_Costo, CC.Descripcion,PCCC.Id_Cta_Contable,PCCC.Id_Cuenta_Padre ' + CHAR(13) +
		'FROM Asientos_Items CCC LEFT JOIN Centro_Costos CC ON CCC.Id_Centro_Costo = CC.Id_Centro_Costo, Pla_Ctas_Cuentas_Contables PCCC' + CHAR(13) +
		'WHERE ' + CHAR(13) +
		'CCC.Id_Cta_Contable = PCCC.Id_Cta_Contable ' + CHAR(13) +
		'AND PCCC.Id_Plan_Cta = ' + CONVERT(VARCHAR(10), @pId_Plan_Cta) + ' '

	IF(@pIncluirCCNoDef = 0)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'AND (CCC.Id_Centro_Costo <> '''' OR CCC.Id_Centro_Costo IS NOT NULL)  '

	IF(@pFlag_FiltrarId_CC <> 0)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'AND CCC.Id_Centro_Costo = '''+  @pId_Centro_Costo    +''' '

	IF(@pSoloResultado = 1)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'AND PCCC.Tipo IN (''+'',''-'') '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'ORDER BY PCCC.Nro_Cta_Contable, CC.Descripcion'
					
	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr   
	--- SELECT * FROM #Rpt_Balance_Saldo_x_Mes_CC
	
	

	/*=============================================================================================================================*/
	UPDATE #Rpt_Balance_Saldo_x_Mes_CC 
	SET 
	Mes_01 = 0,
	Mes_02 = 0,
	Mes_03 = 0,
	Mes_04 = 0,
	Mes_05 = 0,
	Mes_06 = 0,
	Mes_07 = 0,
	Mes_08 = 0,
	Mes_09 = 0,
	Mes_10 = 0,
	Mes_11 = 0,
	Mes_12 = 0,
	Total = 0
	
	--DECLARE curCPJ_BalanceSaldoMesCentro_Rpt CURSOR FOR
	--SELECT 
	--Id_Cta_Contable, 
	--Id_Centro_Costo,
	--Periodo,
	--Saldo
	--FROM #Sumas_Saldos

	--OPEN curCPJ_BalanceSaldoMesCentro_Rpt
	--FETCH NEXT FROM curCPJ_BalanceSaldoMesCentro_Rpt INTO @Alias, @Id_Centro_Costo,@Periodo,@Saldo
	--WHILE @@FETCH_STATUS = 0
	--BEGIN
	
 --        IF DATEPART(mm, @PERIODO) = 1
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_01 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			
 --        IF DATEPART(mm, @PERIODO) = 2
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_02 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
 --        IF DATEPART(mm, @PERIODO) = 3
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_03 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
 --        IF DATEPART(mm, @PERIODO) = 4
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_04 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
 --        IF DATEPART(mm, @PERIODO) = 5
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_05 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
 --        IF DATEPART(mm, @PERIODO) = 6
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_06 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
 --        IF DATEPART(mm, @PERIODO) = 7
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_07 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
 --        IF DATEPART(mm, @PERIODO) = 8
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_08 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
 --        IF DATEPART(mm, @PERIODO) = 9
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_09 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
 --        IF DATEPART(mm, @PERIODO) = 10
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_10 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
 --        IF DATEPART(mm, @PERIODO) = 11
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_11 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
 --        IF DATEPART(mm, @PERIODO) = 12
	--		UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_12 = @Saldo 
	--		       WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			          

	--	FETCH NEXT FROM curCPJ_BalanceSaldoMesCentro_Rpt INTO @Alias, @Id_Centro_Costo,@Periodo,@Saldo
	--END
	--CLOSE curCPJ_BalanceSaldoMesCentro_Rpt
	--DEALLOCATE curCPJ_BalanceSaldoMesCentro_Rpt
	
	--/*=============================================================================================================================*/

	DECLARE curCPJ_BalanceSaldoMesCentro_Rpt CURSOR FOR
	SELECT 
	Id_Cta_Contable, 
	Id_Centro_Costo,
	Periodo,
	Saldo
	FROM #Sumas_Saldos

	OPEN curCPJ_BalanceSaldoMesCentro_Rpt
	FETCH NEXT FROM curCPJ_BalanceSaldoMesCentro_Rpt INTO @Alias, @Id_Centro_Costo,@Periodo,@Saldo
	WHILE @@FETCH_STATUS = 0
	BEGIN
			IF DATEPART(mm,@pPeriodo_Desde)=1
			BEGIN
			 IF DATEPART(mm, @PERIODO) = 1
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_01 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			
			 IF DATEPART(mm, @PERIODO) = 2
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_02 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 3
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_03 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 4
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_04 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 5
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_05 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 6
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_06 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 7
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_07 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 8
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_08 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 9
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_09 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 10
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_10 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 11
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_11 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 12
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_12 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			END
			ELSE
			BEGIN
				IF DATEPART(mm, @PERIODO) = 7
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_01 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			
			 IF DATEPART(mm, @PERIODO) = 8
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_02 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 9
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_03 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 10
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_04 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 11
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_05 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 12
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_06 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 1
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_07 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 2
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_08 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 3
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_09 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 4
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_10 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 5
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_11 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			       
			
			 IF DATEPART(mm, @PERIODO) = 6
				UPDATE #Rpt_Balance_Saldo_x_Mes_CC SET Mes_12 = @Saldo 
					   WHERE ID_Cta_Contable = @Alias AND Id_Centro_Costo = @Id_Centro_Costo 
			END
			          

		FETCH NEXT FROM curCPJ_BalanceSaldoMesCentro_Rpt INTO @Alias, @Id_Centro_Costo,@Periodo,@Saldo
	END
	CLOSE curCPJ_BalanceSaldoMesCentro_Rpt
	DEALLOCATE curCPJ_BalanceSaldoMesCentro_Rpt
	
	/*=============================================================================================================================*/

	
	UPDATE #Rpt_Balance_Saldo_x_Mes_CC 
	SET
	Total = Mes_01 + Mes_02 + Mes_03 + Mes_04 + Mes_05 + Mes_06 + Mes_07 + Mes_08 + Mes_09 + Mes_10 + Mes_11 + Mes_12



	/*=============================================================================================================================*/

	SELECT * FROM #Rpt_Balance_Saldo_x_Mes_CC 
		WHERE	Mes_01 <> 0 OR Mes_02 <> 0 OR Mes_03 <> 0 OR Mes_04 <> 0 OR Mes_05 <> 0 OR Mes_06 <> 0 OR
				Mes_07 <> 0 OR Mes_08 <> 0 OR Mes_09 <> 0 OR Mes_10 <> 0 OR Mes_11 <> 0 OR Mes_12 <> 0
	
	/*=============================================================================================================================*/

	
	/*=============================================================================================================================*/
	DROP TABLE #Asientos_Sumas_Saldos	
	DROP TABLE #Cbtes_Sumas_Saldos
	DROP TABLE #Sumas_Saldos
	DROP TABLE #Rpt_Balance_Saldo_x_Mes_CC
	/*=============================================================================================================================*/

 

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Balance_Sumas_Saldos_Rpt'
	END
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	RETURN 9999
END CATCH

RETURN 0

/*


EXEC dbo.[CPJ_BalanceSaldoMesCentro_Rpt]'{
										"ModoDebug":"1",
										"Id_Usuario":"-1",
										"Periodo_Desde":"20180701",
										"Periodo_Hasta":"20190630",
										"Flag_incluirSoloAsientos":"0",
										"Flag_FiltrarId_CC":"0",
										"Id_Centro_Costo":"0",
										"Id_Plan_Cta":"139",
										"Id_Unid_Negocio":"",
										"Flag_Desglozar_CC":"0",
										"IncluirCCNoDef":"1",
										"Flag_Excluir_Asientos_Cierre":"0"
			}'
			
			


*/
